/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.locale;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Properties;
import net.ftb.gui.LaunchFrame;
import net.ftb.log.Logger;
import net.ftb.util.OSUtils;

public class I18N {
    private static Properties locales = new Properties();
    private static Properties fallback = new Properties();
    private static File dir = new File(OSUtils.getDynamicStorageLocation(), "locale");
    public static HashMap<String, String> localeFiles = Maps.newHashMap();
    public static final HashMap<Integer, String> localeIndices = Maps.newHashMap();
    public static Locale currentLocale = Locale.enUS;

    private static void getLocaleProperties(String file) {
        locales.clear();
        try {
            locales.load(new InputStreamReader(I18N.class.getResource("/i18n/" + file).openStream(), "UTF8"));
        }
        catch (IOException e) {
            Logger.logError("[i18n] Could not load language file", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setupLocale() {
        localeFiles.put("enUS", "English (US)");
        HashMap<Integer, String> hashMap = localeIndices;
        synchronized (hashMap) {
            localeIndices.put(0, "enUS");
        }
        I18N.addFiles();
        LaunchFrame.i18nLoaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addFiles() {
        int i = 1;
        Properties tmp = new Properties();
        for (Locale file_ : Locale.values()) {
            String file = file_.toString();
            try {
                tmp.clear();
                tmp.load(new InputStreamReader(I18N.class.getResource("/i18n/" + file).openStream(), "UTF8"));
                localeFiles.put(file, tmp.getProperty("LOCALE_NAME", file));
                HashMap<Integer, String> hashMap = localeIndices;
                synchronized (hashMap) {
                    localeIndices.put(i, file);
                }
                ++i;
            }
            catch (IOException e) {
                Logger.logWarn("[i18n] Could not load language file", e);
            }
        }
        try {
            fallback.clear();
            fallback.load(new InputStreamReader(I18N.class.getResource("/i18n/enUS").openStream(), "UTF8"));
            Logger.logInfo("[i18n] Fallback enUS loaded");
        }
        catch (IOException e) {
            Logger.logError("[i18n] Could not load fallback file", e);
        }
    }

    public static void setLocale(String locale) {
        if (locale == null) {
            locale = "enUS";
            currentLocale = Locale.enUS;
        } else {
            try {
                currentLocale = Locale.valueOf(locale);
            }
            catch (IllegalArgumentException e) {
                Logger.logWarn("[i18n] Unknown locale " + locale + ". Loaded enUS");
                currentLocale = Locale.enUS;
            }
        }
        I18N.getLocaleProperties(locale);
        Logger.logInfo("[i18n] " + locale + " " + locales.getProperty("LOCALE_LOADED", "loaded"));
    }

    public static String getFallbackString(String key) {
        return fallback.getProperty(key, key);
    }

    public static String getLocaleString(String key) {
        return locales.getProperty(key, I18N.getFallbackString(key));
    }

    public static enum Locale {
        cyGB,
        daDK,
        deDE,
        enUS,
        enGB,
        esES,
        fiFI,
        frFR,
        itIT,
        nlNL,
        noNO,
        maHU,
        ptBR,
        ptPT,
        ruRU,
        svSE,
        zhCN;

    }
}

